﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Project_new.Models;

namespace Project_new.Controllers.QuanLy
{
    public class QuanLyDangNhapController : Controller
    {
        Project_newEntities db = new Project_newEntities();
        // GET: QuanLyDangNhap
        public ActionResult DangNhapQL()
        {
            return View();
        }

        [HttpPost]
        [ValidateAntiForgeryToken()]
        public ActionResult DangNhapQL(Project_new.Models.QuanLy Login)
        {
            try
            {
                var model = db.QuanLies.SingleOrDefault(a => a.TkQL.Equals(Login.TkQL));
                if (model != null)
                {
                    if (model.MkQL.Equals(Login.MkQL))
                    {
                        Session["TkQL"] = model.TkQL;
                        Session["fullName"] = model.HoTenQL;
                        return RedirectToAction("TrangQuanLy", "QuanLyDangNhap");
                    }
                    else
                    {
                        Session["TkQL"] = null;
                        ViewBag.LoginError = "Sai tài khoản hoặc mật khẩu.";
                    }
                }
                else
                {
                    Session["TkQL"] = null;
                    ViewBag.LoginError = "Sai tài khoản hoặc mật khẩu.";
                }
            }
            catch (Exception)
            {
                Session["TkQL"] = null;
                ViewBag.LoginError = "Sai tài khoản hoặc mật khẩu.";
            }
            return View();
        }
        // Trang Quan Ly
        public ActionResult TrangQuanLy()
        {
            if (Session["TkQL"] == null)
            {
                Session["TkQL"] = null;
                return RedirectToAction("DangNhapQL", "QuanLy");
            }
            else
            {
                return View();
            }
        }
        //DangXuat
        public ActionResult DangXuatQL()
        {
            System.Web.Security.FormsAuthentication.SignOut();
            Session["TkQL"] = null;
            return RedirectToAction("DangNhapQL", "QuanLyDangNhap");
        }
    }
}