﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Project_new.Models;

namespace Project_new.Controllers.QuanLy
{
    public class QuanLyNhapHangController : Controller
    {
        private Project_newEntities db = new Project_newEntities();

        // GET: QuanLyNhapHang
        public ActionResult Index(string TimKiemNH = "")
        {
            var nhapHangs = db.NhapHangs.ToList();
            if (!string.IsNullOrEmpty(TimKiemNH))
            {
                TimKiemNH = TimKiemNH.ToUpper();

                nhapHangs = nhapHangs.Where(s =>
                    s.MaPhieuNhap.ToString().ToUpper().Contains(TimKiemNH) ||
                    s.MaPhieuNhap.ToString().ToUpper().Contains(TimKiemNH) ||
                    s.NhaCungCap.ToUpper().Contains(TimKiemNH) ||
                    s.TongTien.ToString().ToUpper().Contains(TimKiemNH) ||
                    s.GhiChu.ToUpper().Contains(TimKiemNH)
                ).ToList(); // Quan trọng: nhớ gọi .ToList()
            }

            return View(nhapHangs);
        }

        // GET: QuanLyNhapHang/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            NhapHang nhapHang = db.NhapHangs.Find(id);
            if (nhapHang == null)
            {
                return HttpNotFound();
            }
            return View(nhapHang);
        }

        // GET: QuanLyNhapHang/Create
        public ActionResult Create()
        {
            return View();
        }

        // POST: QuanLyNhapHang/Create
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "MaPhieuNhap,NgayNhapHang,NhaCungCap,TongTien,GhiChu")] NhapHang nhapHang)
        {
            if (ModelState.IsValid)
            {
                db.NhapHangs.Add(nhapHang);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(nhapHang);
        }

        // GET: QuanLyNhapHang/Edit/5
        public ActionResult Edit(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            NhapHang nhapHang = db.NhapHangs.Find(id);
            if (nhapHang == null)
            {
                return HttpNotFound();
            }
            return View(nhapHang);
        }

        // POST: QuanLyNhapHang/Edit/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "MaPhieuNhap,NgayNhapHang,NhaCungCap,TongTien,GhiChu")] NhapHang nhapHang)
        {
            if (ModelState.IsValid)
            {
                db.Entry(nhapHang).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(nhapHang);
        }

        // GET: QuanLyNhapHang/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            NhapHang nhapHang = db.NhapHangs.Find(id);
            if (nhapHang == null)
            {
                return HttpNotFound();
            }
            return View(nhapHang);
        }

        // POST: QuanLyNhapHang/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            NhapHang nhapHang = db.NhapHangs.Find(id);
            db.NhapHangs.Remove(nhapHang);
            db.SaveChanges();
            return RedirectToAction("Index");
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
